# Отказаться от Stat-а в расчёте feedback_age

[Таска](https://st.yandex-team.ru/NMAPS-15768).

[Код агрегации](https://a.yandex-team.ru/arcadia/maps/wikimap/stat/feedback_age).

[Документация](https://docs.yandex-team.ru/nmaps/stat/feedback_age/Readme).

## Какие задачи решаются

* добавить в результат расчёта дополнительные данные. Для этого надо узнать, какие задачи решают заказчики и подумать.
* Переписать регулярный расчёта без использования statface для хранения данных
* Переключить первые 5ть графиков дашборда на новое хранилище данных
* В случае проблем с агрегацией свежих данных, мониторинг должен писать в телеграм-чат

Есть [расчёт](https://a.yandex-team.ru/arcadia/maps/wikimap/stat/feedback_age), который регулярно агрегирует данные и кладёт их в Stat.

[Stat закрывают](https://clubs.at.yandex-team.ru/statistics/2431). И надо переехать с него.

На основе этого расчёта строится [Дашборд (первые 5 графиков на вкладке "Задания НЯК")](https://datalens.yandex-team.ru/bq3fxpmya6e67-kpi?tab=jn).
Пользователи Дашборда должны не заметить переезда расчёта со стата.

## Исходные данные для расчёта

[Дамп базы](https://yt.yandex-team.ru/hahn/navigation?path=//home/maps/core/nmaps/analytics/feedback/db/feedback_latest)
`social.feedback_task + feedback_history`

## Агрегированные данные на Stat-е

Код расчёта берёт исходные данные и publish-ит агрегированные данные на Stat.

Для фидбэка НК: [Maps.Wiki/Feedback/AgePercentile](https://stat.yandex-team.ru/Maps.Wiki/Feedback/AgePercentile).

Для фидбэка перекрытий: [Maps.Wiki/Feedback/ClosureAgePercentile](https://stat.yandex-team.ru/Maps.Wiki/Feedback/ClosureAgePercentile).

Регулярный запуск организован в [Нирване](https://reactor.yandex-team.ru/reaction?id=8493467&reactionId=2317103&mode=instances).

## Куда перезжать со Stat-а ?

Иными словами: где хранить агрегированные данные?

Решили переезжать в YT. Плюсы и минусы разных подходов описаны ниже.

### Yt таблицы + Nile over Python + Nirvana

#### Плюсы
* [Федя](https://staff.yandex-team.ru/flipper) так сделал с другим расчётом и у него есть инструкция, как повторить этот путь
* Не нужно maintain-ить дополнительную сущность (например базу)
* Можно написать YQL-запрос в YT-табличку и расшарить его с коллегами (с базой это сложнее)
* Писать и тестировать расчёт на Nile over Python проще, чем на C++
* Есть общая клика для всех графиков, которую не надо настраивать и можно использовать. Запущена под алиасом `*maps_clique`.
* Не нужно переписывать тесты
* Не нужно переписывать расчёт

### база Postgresql + worker C++ + Nanny

#### Плюсы
* [Лёха](https://staff.yandex-team.ru/ponomarev) так сделал с другим расчётом
* Доступ в базу - быстрее, чем в YT
* База для статистики - уже есть. Не нужно заводить новую базу.
* Не нужно делать дамп: меньше сущностей нужно поддерживать
* Обновлять агрегацию можно чаще. Сейчас соседний расчёт запускает worker для обновления раз в 2 часа.
* Удобно для каждого Chart-а сделать view-шку. Проверочный запрос в Postgres выполняется секунду, а не минуты, как для случая YT.

## Документация по технологиям
[Stat](https://doc.yandex-team.ru/stat/report-overview/)

[DataLens](https://datalens.yandex-team.ru/docs/overview)

ClickHouse over YT (CHYT): [раз](https://datalens.yandex-team.ru/docs/tutorials/data-from-ch-over-yt),
[два](https://yt.yandex-team.ru/docs/description/chyt/about_chyt.html)
[три](https://clubs.at.yandex-team.ru/yt/3916)

[Nile](https://pages.github.yandex-team.ru/statbox/nile/_modules/nile/api/v1/stream.html)

## Примеры реализации база Postgresql + worker C++ + Nanny

База - общая. [Тут](https://a.yandex-team.ru/svn/trunk/arcadia/maps/wikimap/stat/migrations
) миграции этой базы.

### KPI

[Дашборд](https://datalens.yandex-team.ru/bq3fxpmya6e67-kpi?tab=kWM): вкладки `Edits Processing` и `Deployment`.

[Воркер агрегации](https://a.yandex-team.ru/arcadia/maps/wikimap/mapspro/services/tasks_realtime/src/user_edits_metrics).

В [задаче](https://st.yandex-team.ru/NMAPS-15608) есть ссылки на познавательные ревьюшки.

### Release metrics

[Дашборд](https://datalens.yandex-team.ru/5wcyhpuopo6wy-reliznye-metriki).

[Воркер агрегации](https://a.yandex-team.ru/arcadia/maps/wikimap/mapspro/services/tasks_realtime/src/release_metrics).

## Что нужно добавить в расчёт?

**[in progress]**

На графике возраста фидбэка нужно учитывать только фидбэк, который на расчётный день находится в статусе open.
Сейчас туда учитывается фидбэк в статусе need-info. Кристина говорит, что им нет смысла видеть на этом графике
отправленный в need-info фидбэк. Показатели графика такой фидбэк портит, а сделать с ним сейчас они ничего не могут.
Текущий вариант графика пока не ясно кому нужен.

Добавить измерения по типу и источнику фидбэка.

Каждому графику добавить отдельный селектор по типам и источникам.
Исходно в этих селекторах _накликаны_ значения соответствующие названию графика.

## План по шагам

* перевести хранение агрегированных данных в YT `as is` и скорректировать дашборд на использование YT
  * склонировать расчёт
  * ~~хранить несколько последних расчётов и ссылку на последний ([пример кода](https://a.yandex-team.ru/arcadia/maps/wikimap/stat/dump_feedback_to_yt/main.py?rev=r8273162#L151))~~ пропускаем этот шаг; в дополнительном шаге (см. ниже) задача консистентного обновления результатов будет решена
  * склонировать вкладку дашборда
  * Создать подключение и датасет (это вроде [быстро](https://datalens.yandex-team.ru/docs/concepts/)).
  * Переключить чарты (графики) на новый источник данных. Возможно, создать новые (там 2 способа есть: накликать их через wizard, или же через ChartEditor (писать на js код в разных вкладках, которые запускаются в определённом порядке). Первый вариант более приятный, но не всегда получается сделать то, что хочется). Сейчас все графики в ChartEditor-е написаны.
* внести правки в расчёт (список правок см. в соответствующем параграфе)
* добавить в расчёт новые измерения; результат положить рядом со старым
* добавить график (чарт на языке Datalens) с фильтром (селектор на языке Datalens-а) по новым измерениям; остальные графики оставить "как есть"
* заменить старые чарты новыми с селекторами; для каждого графики должны быть по дефолту установлены выбранными типы и источники соответстующие названию графика
* удалить старый результат расчёта (теперь все графики используют результат расчёта с измерениями)

Дополнительный шаг: сделать расчёт инкрементальным
* добавить в dump колонку last_modified_at
* рассчитывать каждый день только данные за этот день
* в дашборде вместо одной большой таблички использовать много ежедневных
* если тормозит, сделать таблички еженедельными вместо ежедневных