## Release metrics
Метрики релизов данных Народной карты - типы длинных задач, агрегированные в течение дня с максимальным затраченным временем обработки.  
Позволяют визуально определить общий тренд скорости создания релизной ветки, процессинга датасета, экспорта в Огород.  
Система мониторинга позволяет сигнализировать о проблеме, особенно в ночных процессах, когда должна запроцесситься новая ветка и должны отработать проверки датасета к началу рабочего дня у картографов.


### Типы длинных задач

Логика сбора релизных метрик реализована в python-библиотеке.
См. [release_stages.py](https://a.yandex-team.ru/arc_vcs/maps/wikimap/mapspro/libs/python/pymod/yandex/maps/wiki/release_stages.py)  
Учитывается реальное затраченное время (обрабатываются логи длинной задачи), без учета простоя в очереди на исполнение.

| Длинная задача | Краткое описание |
|---|---|
| apply_shadow_attributes | Применение теневых атрибутов после создания релизной ветки. Используется в Jams ARM. |
| create_stable | Создание релизной ветки. Подтвержденым правкам пользователей TDS присваивается релизная ветка, копирование представлений подтвержденной ветки в новую релизную ветку. |
| diffalert | Длинная задача поиска подозрительных правок, запускается по разнице между предыдущей опубликованной веткой и новой релизной. |
| export | Длинная задача экспорта датасета основных объектов в Огород. |
| prepare_stable_branch | Комплексная задача подготовки новой ветки (удаление старой архивной, публикация текущей релизной, создание новой релизной ветки, запуски применения теневых атрибутов и проверок датасета). |
| validation_export | Комплексная задача экспорта и запуск валидаций по регионам. Пакетный экспорт будет отправлен в Огород (или частично), если успешно пройдут мировые валидации и по регионам (частично). |
| validation_full | Любая задача валидации по региону или полному датасету с количеством проверок более 60. |
| validation_rkub | Любая задача валидации по зоне картографирования [RKUB_graf](https://n.maps.yandex.ru/#!/objects/2065384494?z=2&ll=165.288332%2C74.882446&l=nk%23sat) (id: 2065384494) с количеством проверок более 20. |


### Графики
Показания снимаются 1 раз в час, добавляются новые или корректируются текущие значения в [stat-базах](https://yc.yandex-team.ru/folders/foodd8k45ru3cjjo3nte/managed-postgresql?section=list) (см. dataprod_stat_*).

С помощью [Datalens](https://datalens.yandex-team.ru/5wcyhpuopo6wy-reliznye-metriki) визуализируются показатели времени выполнения длинных задач.  


### Мониторинг
При достижении предельных величин срабатывает мониторинг внутри [сервиса](../tasks_realtime.md).  
Актуальные значения значения лимитов в настройках [juggler-проверок](https://a.yandex-team.ru/arc_vcs/maps/wikimap/mapspro/services/tasks_realtime/docker/install/juggler/checks/wiki-release-metrics/MANIFEST.json).

| Длинная задача | Warn | Crit |
|---|---|---|
| apply_shadow_attributes | 4h | 6h |
| create_stable | 4h | 6h |
| diffalert | 2h | 4h |
| export | 7h | 8h |
| prepare_stable_branch | 5h | 7h |
| validation_export | 7h | 8h |
| validation_full | 5h | 6h |

