# merge_poi_worker  
  
Процесс редактирования POI НК с применением данных из Справочника.  
Созладавать POI процесс не умеет.  
  
# Источник данных  
  
## Процесс потребляет таблицы из YT генерируемые в процессе варки базы из справочника.  
Вместо current-state используется версия, URL которой достаётся из самого свежего ресурса SANBOX типа MAPS_DATABASE_BUSINESS_SOURCE_ARCHIVE  
с атрибутоми released  и stable  
  
### Таблица экспортированных карточек Справочника, где есть сигнал из НК  
[nyak_mapping](https://yt.yandex-team.ru/hahn/navigation?path=//home/altay/db/export/state-2020-06-15T23:06:08%2B03:00/snapshot/nyak_mapping)  
Таблица содержит карточки в формате [export.proto](https://a.yandex-team.ru/arc/trunk/arcadia/sprav/protos/export.proto)  
  
### Таблица распубликованных карточек Справочника  
[nyak_mapping_unknown](https://yt.yandex-team.ru/hahn/navigation?path=//home/altay/db/export/current-state/snapshot/nyak_mapping_unknown)  
Содержит список карточек Справочника, куда попали сигналы из НК  
  
### Таблица кандидатов на добавление POI в схемы помещений  
[indoor_candidates](https://yt.yandex-team.ru/hahn/navigation?path=//home/altay/db/export/current-state/nyak/indoor_candidates)  
В таблице экспортированы карточки POI для которых нет сигнала из НК и есть информация о принадлежности некому бизнес/торговому центру.  

### Таблица POI являющихся геопродуктовыми    
[geoproduct]https://yt.yandex-team.ru/hahn/navigation?path=//home/geoadv/export/production/priority_company_permanent_id  
В таблице перечислены пермалинки POI которые особо чувствительны к конфликтам отображения  

### Таблица sprav.tasks Редатора НК  
Таблица содержит информацию на фидбек в Справочник от пользователей через Редактор НК  
  
## Процесс потребляет информацию о последнем экспорте из НК sprav.export_poi_worker_feed_data  
  
# Насройки процесса  
  
## Защищённые объекты  
Это список ft_type объектов, которым никогда не применяются состояния Справочника на этапе варки ymapsdf. Правки процессом проходят обязательную модерацию.  
[Защищённые типы](https://a.yandex-team.ru/arc//trunk/arcadia/maps/garden/modules/ymapsdf/lib/merge_poi/data/merge_poi.json)  
  
## Перечисление ft_type для синхронизации  
Только подмножество незащищённых типов синхронизируется.  
[business_merged_ft_type_ids.xml](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/cfg/editor/business_merged_ft_type_ids.xml)  
  
## Настройки действий по каждому из включённых ft_type  
  
[feed_settings.json](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/cfg/feed_settings.json)  
[схема](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/tasks_sprav/src/merge_poi_worker/cfg/feed_settings.schema.json)  
На данный момент фидбек не генерируется по расстоянию. Правки делаются модерируемыми.  
  
# Процесс работы  
Процесс экспорта запускается по  
[расписанию](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/services/tasks_sprav/docker/install/etc/template_generator/templates/etc/cron.d/wiki-merge-poi-worker)  
Ограничен по времени 6 часами, чтобы не пересекаться с основной массой пользователей.  
  
Правки осуществляются через HTTP клиент редактора НК.  
[editor_client](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/libs/editor_client)  
  
От лица [роботов](https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/robot.h)  
WIKIMAPS_SPRAV_UID - для доверенных правок  
WIKIMAPS_SPRAV_COMMON_UID - для правок требующих проверки (подозрительных)  
  
Этапы:  
1. Считывается актуальный snapshot базы справочника и сравнивается с предыдущим запуском.  
1.1. Если нет обновлений, считывается остаток патчей с прошлого запуска.  
2. Записывается nyak_mapping_unknown  
3. Сравниваются карточки предыдущего запуска, и предыдущего экспорта.  
   Получаем списки карточек Справочника которые поменялись и патчи - которые отличаются от экспорта.  

3.1 Необходимость удаления объекта определяется атрибутами ClosedKind/Unreliable в карточке Справочника  
    Удаление происходит если атрибуты указывают на постоянность и точность "закрытости"  
3.2 Необходимость внесения изменений определяется по  
    - разнице координат между последним экспортом и карточкой  
    - разнице в именах между последним экспортом и карточкой  
    - разнице в значении привязки между последним экспортом и карточкой  

4. Из списка патчей удаляются сигналы на удаление объектов НК, которые попали в одну карточку Справочника  
5. Из списка патчей удаляются сигналы для объектов, синхронизация типов которых ещё не включена  
6. Из списка патчей удаляются сигналы на перемещение объектов в одну позицию в одной карточке.  
7. Составляется список карточек попадающих в одну координату  
8. Карточки на удаление фильтруются используя очередь на удаление. Если объект в очереди 30+ дней - удаление разрешено.  
9. Патчи обрабатываются в многопоточном режиме. Результаты записываются в таблицу sprav.merge_poi_patch_queue_archive.  
10. Создаются задачи фидбека на создание POI в схемах помещений.  
11. Синхронизируется флаг геопродукта с таблицей на YT и создаются задачи модер в случаях конфликтов.  
12. Удаляются POI, созданные Агентом, которые теперь распубликованны.  

## Отложенное удаление (очередь)  
Объекты из НК удаляются не сразу. Сигналы на удаление помещаются в очередь.  
При каждом запуске очередь очищается от сигналов, которых больше нет в Справочнике и сигналов, статус на удаление которых поменялся.  
  
## Обработка патчей (редактирование и удаление объектов НК)  
Запрашивается текущее состояние объекта из Редактора НК.  
Если оно свежее, чем то, на чём построена карточка Справочника, патч игнорируется.  

  
### Удаление объекта НК сигналом справочника.  
Если у объекта проставлен атрибут sys:protected, удаление отменяется.  
Если permalink в НК отличается от permalink Справочника, объект не удаляется, вместо этого обновляется permalink.  
Если для объекта НК есть активная задача на изменение данных в sprav.tasks, сигнал игнорируется.  
Если disp_class объекта НК выше 4го, вместо удаления, создаётся задача через фидбек НК  
Если сигнал на объект схемы помещений, удаление не производится (было: Удаление роботом с модерацией)  
  
В остальных случаях объект НК удаляется, с модерацией в зависимости от настроек для ft_type.  
  
  
### Редактирование объекта НК сигналом справочника.  
#### Геометрия  
- Если расстояние между старой и новой позицией больше настроек для ft_type сигнал помечается как требующий модерации  
- Новая позиция проверяется на попадание в Адреса, Входы и изменение расположения в зданиях.  
Результат записывается. Смена положения относительно зданий и/или попадание в Адрес помечает сигнал как требующий модерации.  
- Если есть другие сигналы полученные в п 7 в этой позиции, сигнал помечается как требующий модерации.  
  
#### permalink  
В объекте НК безусловно устанавливается poi:business_id (Связ со Справочником) как permalink.  
  
#### Имена  
- Имена объекта НК заменяются именами сигнала Справочника того же типа по принципу "все на все"  
- Изменение языка с sr-latn (Сербский латиница) на hr (Хорватский) игнорируется.  
- Если одно из имён сигнала есть имя Рубрики Справочника, сигнал помечается как требующий модерации.  
- Если в новом наборе имён меньший набор языков, сигнал помечается как требующий модерации.  
  
#### Сохранение изменений  
Если у объекта проставлен атрибут sys:protected, правка отменяется.  
Перед сохранением объекта происходит проверка, не является ли изменение частью битвы правок -  
два последовательных сигнала Справочника на этот объект не отличаются друг от друга и источником является гвоздь  
Если это битва - правка отменяется.  
Информация о последней применённой правке хранится в таблице merge_poi_recent_patches  
В эту таблицу также заносится информация редактором НК, если POI создаёт Агент Справочник  
  
Иначе правка сохранаяется одним из роботов.  
Если правка требует безусловной модерации по настройкам ft_type или помечена как требующая модерации и не является гвоздём, то WIKIMAPS_SPRAV_COMMON_UID,  
иначе WIKIMAPS_SPRAV_UID.  
  
#### Верифицированные координаты  
Если в POI в НК для объекта проставлена точность координат Точно или Приблизительно,  
то считается, что координаты верифицированы и изменения надо производить с осторожностью.  
Для таких объектов все правки идут через модерацию, а геометрия меняется только в случае переноса в другое здание.  
  
## Задачи на Создание POI в схемах помещений  
В базе редактора NK поддерживается список permalink, для которых уже созданы задачи.  
Такие записи таблицы indoor_candidates игнорируются.  
  
Каждая запись таблицы проверяется на  
1 попадание в контур уровней опубликованных схем помещений.  
  Если такие есть, задача создаётся.  
2 permalink из поля located_at проверяется на принадлежность объекту НК, который является основной организацией схемы помещений.  
  Если это так, задача создаётся.  

# Отчёты  
Процесс генерирует отчёты:  
[Отчёт об объёмах проведенной и предстоящей работы](https://stat.yandex-team.ru/Maps.Wiki/Sprav/Merge.Poi.Worker)  
[Отчёт об отклонённых правках](https://stat.yandex-team.ru/Maps.Wiki/Sprav/Merge.Poi.Worker.Rejected)  

[Витрина с показателями и графикам по этим отчётам](https://datalens.yandex-team.ru/z52k95w7hgh2t-sprav-nmaps-merge)  
