# wiki-toloka-downloader
Процесс заливки фотографий/гипотез, сделанных пешеходами из Толоки, в подложку НК.

# Исходные данные
Исходные данные - таблицы на YT:
* Экспорт фоток для подъездов с квартирными диапазонами ```//home/offline_data/walkers/maps/entrances/results_good```

# Хранение результата
Данные хранятся в таблицах ```toloka.tasks``` и ```toloka.photos``` кластера mapspro_social.

# Процесс заливки
Уникальным идентификатором задания является пара (pool_id, assignment_id)
Уникальным идентификатором для фотографии считается её URL в хранилище.

Воркер запускается по расписанию в 19:01 каждые сутки, сканирует исходную таблицу,<br/>
пропуская уже обработанные ранее задания (pool_id, assignment_id), скачисвает фотки, регистрирует в нашей базе и заливает в MRC.
Если фотографии сделаны в большом рарешении (не получается залить в MRC), то находим самую большую по размеру фотку и уменьшаем ее, пока не сможем залить в MRC.

Для каждой фотографии из таблиц XXX_photos определяется координата съёмки как координата входа, если таковая есть, иначе как координата POI.
Для каждой фотографии из таблицы raw_desktop берётся координата съёмки, соответствующая ей по тегу - при условии, что в данных для этой фотографии присутствуют обе координаты (съёмки и объекта).
Если координата не найдена, фотография игнорируется.

1. Для каждого обработанного задания создаётся запись в таблице ```toloka.tasks```:
  - ```pool_id``` = ID пула в Толоке
  - ```assignment_id``` = ID задания в Толоке
  - ```created_at``` - время обработки задания на нашей стороне
  - ```task_type``` = тип обрабатываемого задания (entrance - задания на обработку фоток известных подъездов)
  - ```data``` - сериализованные входные данные в json - строка yt-таблицы
  - ```status``` - статус обработки задание (processing, failed, ok)

2. Для каждой фотографии с координатой
  * Происходит заливка в сервис MRC и получение ```photo_id```.
  * Создаётся запись в таблице ```tasks.photos```
    - ```pool_id``` = ID пула в Толоке
    - ```assignment_id``` = ID задания в Толоке
    - ```created_at``` - время обработки задания на нашей стороне
    - ```attachment_id``` = URL фотографии в хранилище
    - ```photo_id``` = ID фотографии в сервисе MRC

3. Сервис MRC обрабатывает полученные фотографии к объекту, создает гипотезу в НК с источником ```toloka-pedestrian-onfoot```
Сами фотографии также отображаются сервисом MRC через точки съёмки на подложке.
