Оплата выполненых в Трекере задач
=================================
Ряд работ оплачивается по факту выполнения задач в Трекере в очередях:
[MAPSPW][] и [OUTKARTPW][].

Для каждой задачи обязательно указание ровно одного компонента. Компонент
определяет тариф для задачи. Обычно _Имя тарифа_ и _Компонент_
совпадают. Например:

    - tariff_name: Антивандальное дежурство
      seconds: 20000
      rub: 1000
      tasks:
        - Антивандальное дежурство

В отчет [Tasks Payment][report] задачи попадают в виде `all/Трекер/Имя
тарифа/Компонент`.

Задачи в трекере разнородны по своей природе, поэтому объём выполненной работы
может измеряться в разных единицах измерения: штуки, дни, км, км^2^, ... Единицы
измерения нигде явно не указываются и зависят от выполняемой работы. А само
количество единиц работы указывается в поле _Agile / Story Points_. Например:
- 1 (дежурство);
- 31.2 (км^2^);
- 5 (очков сложности);
- ...

Стоимость задачи определяется произведением _Story Points_ и цены, указанной в
тарифе.


Воркфлоу
--------
Задачи в этих очередях изменяют своё состояние в соответствии со следующей
диаграммой:

![Workflow](_images/tracker-workflow.svg)

В очередях настроены триггеры проверяющие правильность заполнения необходимых
для расчёта заработной платы полей. Если поля заполнены неправильно, то задача
автоматически возвращается в состояние _В работе_, также к ней добавляется
комментарий с описанием возникшей проблемы. В таком случае необходимо исправить
проблему и снова попытаться закрыть задачу.

{% note warning %}

После закрытия задачи недопустимо изменять поля _Story Points_ и _Компоненты_.

{% endnote %}


Расчёт заработной платы
-----------------------
Датой выполнения задачи считается дата **первого** перевода задачи в состояние
_Закрыт_. Именно эта дата используется для расчёта заработной платы.

В расчёте заработной платы участвуют только задачи закрытые с резолюцией
_Решён_.

Выполненная работа подсчитывается с помощью утилиты [Cartographic Log][].


Проверка выполненной работы
---------------------------
Для назначения проверяющего картографа используется поле _Эксперт_.

В очередях настроен триггер создающий связанную задачу на проверку для
задач закрываемых с заполненным полем _Эксперт_ .


Синхронизация компонент и тарифов
---------------------------------
Компоненты в очередях соответствуют тарифам. Для поддержания списка компонентов
в Трекере в актуальном состоянии компоненты синхронизируются несколько раз в
день с [тарифами][tariff] с помощью [утилиты синхронизации][tariffs_to_components].

Синхронизация запускается реакцией [Sync Tariffs to Components][sync reaction].


Требования к очереди для подключения её к автоматическому расчёту заработной платы
----------------------------------------------------------------------------------
Для расчёта заработной платы принимаются только задачи закрытые с резолюцией
_Решён_ и с правильно заполненными полями:
- Компоненты (должен быть ровно один);
- Исполнитель;
- Story Points.


### Рекомендуемые настройки
- `Основные параметры / Расширенные настройки / Обязательные для отображения
  поля`: Компоненты, Story Points, Эксперт.
- `Доступ / Права доступа / Люди и роботы`: robot-wikimap (создание, просмотр
  задач, редактирование задач и настройка очереди).
- `Типы задач / Резолюции`: Решен, Не будет исправлено, Дубликат.
- `Воркфлоу`: для переходов в состояние _Закрыт_ рекомендуется настроить экран
  перехода со следующими полями: Резолюция (обязательное), Исполнитель
  (обязательное), Компоненты (обязательное), Story Points (обязательное),
  Эксперт.
- Автоматизация / Триггеры. Рекомендуется создать следующие тригеры:
  1. Проверка компонентов:
     - Условия срабатывания: `Статус` стало равно _Закрыт_ и `Компоненты количество
       элементов` не равно 1.
     - Действие триггера: переход в статус _В работе_ и отправка сообщения от
       имени робота _Задача может быть закрыта только при условии, что указан
       ровно один компонент._ с призывом в комментарии автора и исполнителя.
     - Для работы этого триггера необходимо наличие перехода из статуса _Закрыт_
       в статус _В работу_.
  2. Создание задачи на проверку:
     - Условия срабатывания: `Статус` стало равно _Закрыт_, `Резолюция` равно
       _Решён_ и `Эксперт` значение поля не пусто.
     - Действие триггера: HTTP-запрос:
       - Метод: `POST`.
       - Адрес: `https://st-api.yandex-team.ru/v2/issues/`.
       - Способ авторизации: OAuth 2.0.
       - Токен: токен робота robot-wikimap.
       - Тип токена: OAuth.
       - Тип содержимого: `application/json`.
       - Тело запроса:
       ```
       {
           "summary": "Проверка {{issue.key}} {{issue.summary}}",
           "queue": "MAPSPW",
           "assignee": "{{issue.expert.login}}",
           "links": [
               {
                   "relationship": "relates",
                   "issue": "{{issue.key}}"
               }
           ]
       }
       ```


[MAPSPW]:                https://st.yandex-team.ru/MAPSPW
[OUTKARTPW]:             https://st.yandex-team.ru/OUTKARTPW
[cartographic log]:      https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/stat/tasks_payment/tasks_logging/tracker/cartographic_log
[report]:                https://stat.yandex-team.ru/Maps.Wiki/tasks_payment/Tasks_Payment
[sync reaction]:         https://nirvana.yandex-team.ru/browse?selected=7408212
[tariff]:                https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/stat/tasks_payment/dictionaries/tariff
[tariffs_to_components]: https://a.yandex-team.ru/arc/trunk/arcadia/maps/wikimap/stat/tasks_payment/tariffs_to_components
