#include <maps/wikimap/mapspro/libs/acl/include/acl_tool.h>

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl/include/exception.h>
#include <maps/wikimap/mapspro/libs/acl/include/permission.h>

#include <yandex/maps/wiki/common/string_utils.h>
#include <maps/libs/xml/include/xml.h>
#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::acl {

namespace {

const std::string XML_ID = "id";
const std::string HELP = "help";
const std::string CONNECTION = "connection";
const std::string PERMISSION = "permission";
const std::string PERMISSIONS = "permissions";

struct CreateOrGet
{
    Permission permission;
    bool created = false;
};

CreateOrGet
createOrGetChild(const Permission& perm, const std::string& childName)
{
    try {
        return {perm.childPermission(childName)};
    } catch (const PermissionNotExists&) {
        INFO() << "Creating permission: " << (perm.name() + "/" + childName);
        return
            {
                perm.createChildPermission(childName),
                true
            };
    }
}

CreateOrGet
createOrGetRoot(ACLGateway& gateway, const std::string& rootName)
{
    try {
        return {gateway.rootPermission(rootName)};
    } catch (const PermissionNotExists&) {
        INFO() << "Creating root permission: " << rootName;
        return
            {
                gateway.createRootPermission(rootName),
                true
            };
    }
}

bool
walk(const maps::xml3::Node& permNode, const Permission& perm)
{
    maps::xml3::Node childPermNode = permNode.firstElementChild(PERMISSION);
    bool newNodes = false;
    while (!childPermNode.isNull()) {
        auto childResult = createOrGetChild(
                perm,
                childPermNode.attr<std::string>(XML_ID));
        newNodes = walk(
            childPermNode,
            childResult.permission) || newNodes || childResult.created;
        childPermNode = childPermNode.nextElementSibling(PERMISSION);
    }
    return newNodes;
}

} // namespace

bool
fillPermissionsTree(ACLGateway& gateway, const maps::xml3::Doc& permissionsDoc)
{
    maps::xml3::Node permNode = permissionsDoc.root().firstElementChild(PERMISSION);
    bool createdNewNodes = false;
    while (!permNode.isNull()) {
        auto rootResult =
            createOrGetRoot(gateway, permNode.attr<std::string>(XML_ID));
        createdNewNodes =
            walk(permNode, rootResult.permission) ||
            createdNewNodes ||
            rootResult.created;
        permNode = permNode.nextElementSibling(PERMISSION);
    }
    return createdNewNodes;
}

} // namespace maps::wiki::acl
