#include <maps/wikimap/mapspro/libs/acl/include/banrecord.h>
#include <maps/libs/enum_io/include/enum_io.h>

#include <iostream>
#include <string>

namespace maps::wiki::acl {

namespace {

constexpr enum_io::Representations<BanRecord::Action> ACTION_ENUM_REPRESENTATION {
    {BanRecord::Action::Ban, "ban"},
    {BanRecord::Action::Unban, "unban"}
};

} // namespace

DEFINE_ENUM_IO(BanRecord::Action, ACTION_ENUM_REPRESENTATION);

BanRecord::BanRecord(
    ID id, UID uid, Action action,
    std::string created, UID createdBy,
    std::string expires,
    std::string reason)
    : id_(id)
    , uid_(uid)
    , action_(action)
    , created_(std::move(created))
    , createdBy_(createdBy)
    , expires_(std::move(expires))
    , reason_(std::move(reason))
{
}

} // namespace maps::wiki::acl
