#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <set>

namespace maps::wiki::acl {

class ClusterManager
{
public:
    explicit ClusterManager(Transaction& work);
    ID requestCluster(
        const std::set<ID>& groupIds,
        const std::set<ID>& roleIds);

    void assignCluster(ID agentId, ID clusterId);
    void releaseClusterByAgentId(ID agentId);

    std::set<ID> keyRoleAffectedClusters(ID roleId) const;
    std::set<ID> keyGroupAffectedClusters(ID groupId) const;

    void updateClusters(const std::set<ID>& clusterIds);
    void removeClustersWithoutRefs();

    void updateUserCluster(ID userId);
    void updateGroupCluster(ID groupId);
    void updateAgentsClusters(bool onlyMissing);

    void enqueueAll();
    void enqueueClusters(const std::set<ID>& clusterIds);
    void enqueueGroupCluster(ID groupId);
    void enqueueUserCluster(ID userId);
    size_t processClustersUpdateQueue();
    size_t clustersUpdateQueueSize() const;

private:
    Transaction& work_;
};

} // namespace maps::wiki::acl
