#include <maps/wikimap/mapspro/libs/acl/include/deleted_users_cache.h>
#include <maps/wikimap/mapspro/libs/acl/include/exception.h>

namespace maps::wiki::acl {

namespace {

const std::string DELETED_UIDS_QUERY = "SELECT uid FROM acl.user WHERE status = 'deleted'";

} // namespace

bool
DeletedUsersCache::isAllowed(UID uid) const
{
    std::lock_guard<std::mutex> lock(mutex_);
    return deletedUsers_.count(uid) == 0;
}

void
DeletedUsersCache::checkUser(UID uid) const
{
    if (!isAllowed(uid)) {
        throw AccessDenied(uid) << " is deleted";
    }
}

void
DeletedUsersCache::addUser(UID uid) const
{
    if (!uid) {
        return;
    }
    std::lock_guard<std::mutex> lock(mutex_);
    deletedUsers_.emplace(uid);
}

void
DeletedUsersCache::update(Transaction& txn)
{
    std::unordered_set<UID> uids;
    for (const auto& row : txn.exec(DELETED_UIDS_QUERY)) {
        uids.emplace(row[0].as<UID>());
    }

    std::lock_guard<std::mutex> lock(mutex_);
    deletedUsers_.swap(uids);
}

} // namespace maps::wiki::acl
