#include "exception_helper.h"

#include <maps/wikimap/mapspro/libs/acl/include/common.h>

namespace maps::wiki::acl {

void
convertException()
{
    try
    {
        throw;
    } catch (const ACLException&) {
        throw;
    } catch (const maps::Exception& ex) {
        throw ACLException() << ex.what();
    } catch (const pqxx::foreign_key_violation& ex) {
        throw RelatedObjects() << ex.what();
    } catch (const pqxx::unique_violation& ex) {
        throw ACLException() << "Unhandled unique_violation: " << ex.what();
    } catch (const std::exception& ex) {
        throw ACLException() << ex.what();
    }
}

} // namespace maps::wiki::acl
