#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/wikimap/mapspro/libs/acl/include/role.h>

#include <string>
#include <vector>

namespace maps::wiki::acl {

class User;
class BanRecord;
class Group;
class Aoi;
class Policy;
class Permission;
class Permissions;
class Schedule;
class ScheduledPolicy;
class ScheduledGroup;

enum class Deleted : bool;

class Factory
{
public:
    static User user(const pqxx::row& row, Transaction& work);
    static BanRecord banRecord(const pqxx::row& row);
    static Group group(const pqxx::row& row, Transaction& work);
    static Group group(ID, const std::string& name, const std::string& description, Transaction& work);
    static Role role(ID id, const std::string& name, const std::string& description, Role::Privacy privacy, Transaction& work);
    static Aoi aoi(ID id, const std::string& name, const std::string& wkb, Deleted deleted);
    static Policy policy(ID agentId, Role role, ID aoiId, Transaction& work);
    static Permission permission(ID id, const std::string& name, ID parentId, Transaction& work);
    static Permissions permissions(std::vector<Permission>&& data);

    static Schedule schedule(const pqxx::row& row);
    static Schedule schedule(
        ID id,
        const std::string& startDate,
        const std::optional<std::string>& endDate,
        const std::optional<std::string>& startTime,
        const std::optional<std::string>& endTime,
        const std::optional<int>& weekdays,
        const std::optional<std::string>& workRestDays);
    static ScheduledPolicy scheduledPolicy(
        ID agentId, ID roleId, ID aoiId,
        const Schedule& schedule);
    static ScheduledGroup scheduledGroup(
        ID userId, ID groupId,
        const Schedule& schedule);
};

} // namespace maps::wiki::acl
