#include <maps/wikimap/mapspro/libs/acl/include/policy.h>
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>

namespace maps::wiki::acl {

Policy::Policy(ID agentId, Role role, ID aoiId, Transaction& work)
    : agentId_(agentId)
    , role_(std::move(role))
    , aoiId_(aoiId)
    , work_(work)
{
}

Aoi
Policy::aoi() const
{
    return ACLGateway(work_).aoi(aoiId_);
}

bool
isExistingPolicy(
    const std::vector<acl::Policy>& policies,
    acl::ID roleId,
    acl::ID aoiId)
{
    return std::any_of(
        policies.begin(),
        policies.end(),
        [&](const auto& policy) {
            return policy.roleId() == roleId &&
                   policy.aoiId() == aoiId;
        });
}

} // namespace maps::wiki::acl
