#include <maps/wikimap/mapspro/libs/acl/include/restricted_users.h>

namespace maps::wiki::acl {

namespace {

namespace table {

const std::string RESTRICTED_USERS = "acl.restricted_users";

} // namespace table

namespace column {

const std::string RESTRICTION_REASON = "restriction_reason";
const std::string UID = "uid";

} // namespace column

} // namespace

void
restrictUser(Transaction& txn, UID uid, const std::string& reason)
{
    txn.exec(
        "INSERT INTO " + table::RESTRICTED_USERS +
        "(" + column::UID + "," + column::RESTRICTION_REASON + ") VALUES (" +
        std::to_string(uid) + "," + txn.quote(reason) + ") ON CONFLICT DO NOTHING");
}

void
unrestrictUser(Transaction& txn, UID uid)
{
    txn.exec(
        "DELETE FROM " + table::RESTRICTED_USERS +
        " WHERE " + column::UID + " = " + std::to_string(uid));
}

bool
isUserRestricted(Transaction& txn, UID uid)
{
    auto r = txn.exec(
        "SELECT FROM " + table::RESTRICTED_USERS +
        " WHERE " + column::UID + " = " + std::to_string(uid));
    return !r.empty();
}

} // namespace maps::wiki::acl
