#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>

namespace maps::wiki::acl {

enum class Deleted : bool
{
    No = false,
    Yes = true
};

class Aoi
{
public:
    friend class Factory;

    ID id() const { return id_; }
    const std::string& name() const { return name_; }
    const std::string& wkb() const { return wkb_; }
    Deleted deleted() const { return deleted_; }

private:
    Aoi(ID id, const std::string& name, const std::string& wkb, Deleted deleted)
        : id_(id), name_(name), wkb_(wkb), deleted_(deleted)
    {}

    ID id_;
    std::string name_;
    std::string wkb_;
    Deleted deleted_;
};

} // namespace maps::wiki::acl
