#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>

#include <iosfwd>
#include <memory>
#include <string>

namespace maps::wiki::acl {

class BanRecord
{
public:
    enum class Action
    {
        Ban,
        Unban
    };

    friend class Factory;

    ID id() const { return id_; }
    UID uid() const { return uid_; }
    Action action() const { return action_; }
    const std::string& created() const { return created_; }
    UID createdBy() const { return createdBy_; }
    const std::string& expires() const { return expires_; }
    const std::string& reason() const { return reason_; }

private:
    BanRecord(ID id, UID uid, Action action,
        std::string created, UID createdBy,
        std::string expires,
        std::string reason);

    ID id_;
    UID uid_;
    Action action_;
    std::string created_;
    UID createdBy_;
    std::string expires_;
    std::string reason_;
};

DECLARE_ENUM_IO(BanRecord::Action);

} // namespace maps::wiki::acl
