#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <yandex/maps/wiki/common/geom.h>

#include <map>
#include <set>
#include <string>
#include <vector>

namespace maps::wiki::acl {

/**
 * Context for performing permissions checks
 */
class CheckContext
{
public:
    friend class SubjectPath;

    /**
     * Construct context for checking permissions
     * @param uid to check rights for
     * @param geoms is WKBs vector to check against AOI
     * @param transaction to access ACL database
     * @param set of user statuses allowed by context
     */
    CheckContext(
        UID uid,
        const std::vector<std::string>& wkbs,
        Transaction& work,
        std::set<User::Status> allowedUserStatuses);

    CheckContext(
        const User& user,
        const std::vector<std::string>& wkbs,
        Transaction& work,
        std::set<User::Status> allowedUserStatuses);

    UID uid() const { return uid_; }

    CheckContext narrow(
        const std::vector<std::string>& wkbs,
        Transaction& work);

    CheckContext inflate() const;

private:
    CheckContext(
        UID uid,
        std::set<std::string> allowedPaths);

    void init(
        const User& user,
        const std::vector<std::string>& wkbs,
        Transaction& work,
        std::set<User::Status> allowedUserStatuses);

    void loadAoiGeoms(Transaction& work);

    UID uid_;
    std::set<std::string> allowedPaths_;

    bool isGlobal_;
    std::map<std::string, std::set<ID>> pathToAoiIds_;

    bool aoiGeomsLoaded_;
    std::map<ID, common::Geom> aoiGeoms_;
};

} // namespace maps::wiki::acl
