#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>

#include <mutex>
#include <unordered_set>

namespace maps::wiki::acl {

class DeletedUsersCache
{
public:
    bool isAllowed(UID uid) const;

    // throws AccessDenied exception if user is deleted
    void checkUser(UID uid) const;

    void addUser(UID uid) const;

    void update(Transaction& txn);

private:
    mutable std::unordered_set<UID> deletedUsers_;
    mutable std::mutex mutex_;
};

} // namespace maps::wiki::acl
