#pragma once

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::acl {

class ACLException : public maps::Exception
{
public:
    virtual const char* type() const { return "WikiACL Error"; }
};

class ACLLogicError : public ACLException
{
};

class UserNotExists : public ACLException
{
};

class PermissionNotExists : public ACLException
{
};

class RoleNotExists : public ACLException
{
};

class GroupNotExists : public ACLException
{
};

class AoiNotExists : public ACLException
{
};

class ScheduleNotExists : public ACLException
{
};

class RelatedObjects : public ACLException
{
};

class DuplicateRelation : public ACLException
{
};

class DuplicateRole : public ACLException
{
};

class DuplicateGroup : public ACLException
{
};

class DuplicateUser : public ACLException
{
};

class DuplicatePermission : public ACLException
{
};

class DuplicatePolicy : public ACLException
{
};

class BadParam : public ACLException
{
};

class AccessDenied : public ACLException
{
public:
    AccessDenied() = default;

    template <typename TUid>
    explicit AccessDenied(TUid uid)
    {
        *this << "User with uid " << uid;
    }
};

} // namespace maps::wiki::acl
