#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>

#include <string>
#include <vector>

namespace maps::wiki::acl {

class Policy;
class User;

class Group
{
public:
    friend class Factory;

    ID id() const { return id_; }
    const std::string& name() const { return name_; }
    void setName(const std::string& newName);

    const std::string& description() const { return description_; }
    void setDescription(const std::string& newDescription);

    void add(const User& user) const;
    void remove(const User& user) const;

    std::vector<User> users() const;
    std::vector<Policy> policies() const;
    void removePolicy(ID roleID, ID aoiID) const;
    void removePolicies() const;

private:
    Group(
        ID id,
        const std::string& name,
        const std::string& description,
        Transaction& work);

    ID id_;
    std::string name_;
    std::string description_;

    Transaction& work_;
};

bool
isExistingGroup(
    const std::vector<acl::Group>& groups,
    acl::ID groupId);

} // namespace maps::wiki::acl
