#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/wikimap/mapspro/libs/acl/include/role.h>

#include <functional>
#include <string>
#include <vector>

namespace maps::wiki::acl {
class ACLGateway;

class Permission
{
public:
    friend class Factory;

    ID id() const { return id_; }
    ID parentId() const { return parentId_; }
    const std::string& name() const { return name_; }
    std::vector<ID> leafIds() const;

    Permission createChildPermission(const std::string& newName) const;
    Permission childPermission(const std::string& childName) const;
    std::vector<Role> roles() const;

    void updateLeafsIds(ACLGateway& gw);

private:
    Permission(ID id, const std::string& name, ID parentId, Transaction& work);

    ID id_;
    std::string name_;
    ID parentId_;
    std::reference_wrapper<Transaction> work_;
};

} // namespace maps::wiki::acl
