#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/permission.h>

#include <list>
#include <map>
#include <vector>

namespace maps::wiki::acl {

class Factory;

class Permissions
{
public:
    friend class Factory;

    const std::vector<Permission>& data() const { return data_; }

    std::vector<Permission> roots() const;

    std::vector<Permission> children(const Permission& permission) const;
    std::list<std::string> path(const Permission& permission) const;

    Permission permission(const std::list<std::string>& path) const;

private:
    explicit Permissions(std::vector<Permission> data);

    const Permission& checkedPermission(ID id) const;

    Permission rootPermission(const std::string& name) const;
    Permission childPermission(
        const Permission& permission,
        const std::string& childName) const;

    std::vector<Permission> data_;
    std::map<ID, std::vector<Permission>::const_iterator> id2ptr_;
};

} // namespace maps::wiki::acl
