#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/aoi.h>
#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/wikimap/mapspro/libs/acl/include/role.h>

#include <string>

namespace maps::wiki::acl {

class Policy
{
public:
    friend class Factory;

    ID agentId() const
    { return agentId_; }

    ID roleId() const
    { return role_.id(); }

    Role role() const
    { return role_; }

    ID aoiId() const
    { return aoiId_; }

    Aoi aoi() const;

private:
    Policy(ID agentId, Role role, ID aoiId, Transaction& work);

    ID agentId_;
    Role role_;
    ID aoiId_;
    Transaction& work_;
};

bool
isExistingPolicy(
    const std::vector<acl::Policy>& policies,
    acl::ID roleId,
    acl::ID aoiId);

} // namespace maps::wiki::acl
