#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/check_context.h>

#include <istream>
#include <list>
#include <string>

namespace maps::wiki::acl {

class SubjectPath
{
public:
    SubjectPath();
    explicit SubjectPath(const std::string& root);

    const std::list<std::string>& pathParts() const
    { return pathParts_; }

    /**
     * Increase depth of the path by additional permission level
     * @param level is new level to add at tail
     * @return reference to this
     */
    SubjectPath operator()(const std::string& level) const;

    bool isAllowed(const CheckContext& context) const;
    bool isAllowedPartially(const CheckContext& context) const;

    /**
     * Check whether writes are allowed at this path
     * location within given context
     * @throws AccessDenied if check failed
     */
    void check(const CheckContext& context) const;

    /**
     * Check whether  writes are allowed at sub paths of this path
     * location within given context
     * @throws AccessDenied if check failed
     */
    void checkPartialAccess(const CheckContext& context) const;

    std::string str() const;

    friend std::istream& operator>>(
        std::istream& is,
        SubjectPath& path);

private:
    std::list<std::string> pathParts_;
};

std::istream& operator>>(std::istream& is, SubjectPath& path);

} // namespace maps::wiki::acl
