#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/cached_moderation_statuses.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/moderation.h>
//
#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/log8/include/log8.h>
#include <yandex/maps/wiki/common/default_config.h>
#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/common/pgpool3_helpers.h>

#include <string>
#include <memory>

namespace acl = maps::wiki::acl;
namespace common = maps::wiki::common;
namespace aclu = maps::wiki::acl_utils;

namespace {

const std::string ACL_DB_ID = "long-read";
const std::string ACL_POOL_ID = "long-read";

} // namespace

int main(int argc, char** argv)
{
    // Get DB pool.
    maps::cmdline::Parser parser;
    auto workerConfig =
        parser.file("config").help("path to services configuration file.");
    parser.parse(argc, argv);
    std::unique_ptr<common::ExtendedXmlDoc> configDocPtr;
    if (workerConfig.defined()) {
        configDocPtr = std::make_unique<common::ExtendedXmlDoc>(workerConfig);
    } else {
        configDocPtr = common::loadDefaultConfig();
    }
    common::PoolHolder aclPoolHolder(*configDocPtr, ACL_DB_ID, ACL_POOL_ID);
    auto& pool = aclPoolHolder.pool();

    // Launch CachedModStatuses.
    const auto refreshPeriod = std::chrono::minutes(2);

    const auto userGroups = maps::enum_io::enumerateValues<aclu::UserGroup>();
    for (auto group: userGroups) {
        INFO() << group << "\tcache init started.";
        aclu::UserGroupUidsCache cache{group, pool, refreshPeriod};
        INFO() << group << "\tcache init finished.";

        auto uids = cache.uids();
        INFO() << "Got " << uids->size() << " uids";
    }
}
