#include <maps/wikimap/mapspro/libs/acl_utils/include/caching_acl.h>
#include <maps/wikimap/mapspro/libs/acl/include/subject_path.h>

#include <maps/libs/log8/include/log8.h>

namespace maps::wiki::acl_utils {

bool CachingAclChecker::userHasPermission(acl::UID uid, const std::string& permission)
{
    auto checkCtx = getCheckContext(uid);
    REQUIRE(checkCtx, "checkCtx is not defined");
    return acl::SubjectPath(permission).isAllowed(checkCtx->ctx);
}

bool CachingAclChecker::userHasPartOfPermission(acl::UID uid, const std::string& permission)
{
    auto checkCtx = getCheckContext(uid);
    REQUIRE(checkCtx, "checkCtx is not defined");
    return acl::SubjectPath(permission).isAllowedPartially(checkCtx->ctx);
}

void CachingAclChecker::checkPermission(acl::UID uid, const std::string& permission)
{
    auto checkCtx = getCheckContext(uid);
    REQUIRE(checkCtx, "checkCtx is not defined");
    acl::SubjectPath(permission).check(checkCtx->ctx);
}

std::shared_ptr<TimedCheckContext> CachingAclChecker::getCheckContext(acl::UID uid)
{
    auto now = std::chrono::steady_clock::now();

    auto evalCheckContext = [&](acl::UID uid) {
        INFO() << "loading permissions of user " << uid;
        auto txn = pgPool_.slaveTransaction();
        acl::CheckContext ctx(uid, {} /* aoi geoms */, txn.get(), {acl::User::Status::Active});
        return TimedCheckContext{std::move(ctx), now};
    };

    auto value = cache_.getOrEmplace(uid, evalCheckContext);

    if (value) {
        if (now - value->created < expirationPeriod_) {
            return value;
        } else {
            INFO() << "cached permissions of user " << uid << " has expired";
        }
    }

    return cache_.put(uid, evalCheckContext(uid));
}

} // namespace maps::wiki::acl_utils
