#include <maps/wikimap/mapspro/libs/acl_utils/include/moderation.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/user_feed_access.h>

#include <maps/libs/common/include/exception.h>

namespace maps::wiki::acl_utils {

bool
isUserAllowedToReadFeed(
    pqxx::transaction_base& coreTxn,
    acl::UID readerUid,
    acl::UID feedUid)
{
    ASSERT(feedUid);
    if (readerUid == feedUid) {
        return true;
    }

    std::string readerModerationStatus;

    acl::ACLGateway aclGw(coreTxn);
    if (readerUid) {
        const auto readerUser = aclGw.user(readerUid);
        if (readerUser.status() == acl::User::Status::Deleted) {
            return false;
        }

        readerModerationStatus = moderationStatus(aclGw, readerUser);
        if (isCartographer(readerModerationStatus)) {
            return true;
        }
    }

    const auto feedUser = aclGw.user(feedUid);
    auto feedModerationStatus = moderationStatus(aclGw, feedUser);

    if (isYandexModerator(feedModerationStatus) && isYandexModerator(readerModerationStatus)) {
        return true;
    }

    return !isRobot(feedModerationStatus) &&
           !isYandexModerator(feedModerationStatus) &&
           !isCartographer(feedModerationStatus) &&
           !isOutsourcer(feedUser);
}

} // namespace maps::wiki::acl_utils
