#include <maps/wikimap/mapspro/libs/acl_utils/include/user_kind.h>

#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/moderation.h>
#include <maps/libs/common/include/exception.h>
#include <yandex/maps/wiki/common/moderation.h>

namespace maps::wiki::acl_utils {
// clang-format off
constexpr maps::enum_io::Representations<UserKind> FEED_TYPE_REPRESENTATION{
        {UserKind::Robots, "robots"},
        {UserKind::Self,   "self"},
        {UserKind::Yandex, "yandex"}
};
DEFINE_ENUM_IO(UserKind, FEED_TYPE_REPRESENTATION);

const std::vector<UserGroup> YANDEX_USER_GROUPS = {
    UserGroup::Cartographer,
    UserGroup::YandexModerator,
    UserGroup::Robot,
    UserGroup::Outsourcer
};
// clang-format on

namespace {

std::set<acl::UID> userGroupsUids(
    const acl_utils::UserGroupsUidsCache& cachedUids,
    const std::vector<UserGroup>& userGroups)
{
    std::set<acl::UID> uids;
    for (auto group: userGroups) {
        const auto tmp = cachedUids.at(group)->uids();
        uids.insert(tmp->begin(), tmp->end());
    }
    return uids;
}

std::set<acl::UID> userKindValueToUids(
    const UserGroupsUidsCache& cachedUids,
    const UserKind& userKind,
    acl::UID selfUid)
{
    switch (userKind) {
        case UserKind::Robots:
            return userGroupsUids(cachedUids, {UserGroup::Robot});
        case UserKind::Yandex:
            return userGroupsUids(cachedUids, YANDEX_USER_GROUPS);
        case UserKind::Self:
            return {selfUid};
        default:
            REQUIRE(
                false,
                "Unexpected skip-created-by value '" << userKind << "'.");
    }
}

} // namespace

std::set<acl::UID> userKindsToUids(
    const std::vector<UserKind>& userKinds,
    acl::UID selfUid,
    const acl_utils::UserGroupsUidsCache& cachedUids)
{
    std::set<acl::UID> result;
    for (const auto& userKind: userKinds) {
        auto uids = userKindValueToUids(cachedUids, userKind, selfUid);
        result.insert(uids.begin(), uids.end());
    }
    return result;
}

} // namespace maps::wiki::acl_utils
