#pragma once
#include <maps/libs/concurrent/include/background_thread.h>
#include <maps/libs/enum_io/include/enum_io.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/libs/acl/include/common.h>

#include <chrono>
#include <memory>
#include <shared_mutex>
#include <vector>

namespace maps::wiki::acl_utils {

/**
 * UserGroup contains:
 *  chosen moderation Statuses
 *  outsourcers.
 * Users with 'common' moderation status are not included
 * because new 'common's are being created every minute.
 * Therefore cache is almost immediately outdated.
 * In addition, there are millions of 'common' users
 * and fetching them is long.
 **/
enum class UserGroup {
    Robot,
    Cartographer,
    YandexModerator,
    Outsourcer
};
DECLARE_ENUM_IO(UserGroup);

using UidsPtr = std::shared_ptr<std::vector<acl::UID>>;

/**
 * Cache keeps and periodically refreshes
 * uids for specified user group.
 **/
class UserGroupUidsCache {
public:
    UserGroupUidsCache(
        UserGroup userGroup,
        pgpool3::Pool& aclPool,
        std::chrono::minutes updatePeriod);

    UidsPtr uids() const;

private:
    void updateDataThreadSafeNoExcept();

    UidsPtr fetchUids();
    void updateUids();

    const UserGroup userGroup_;
    pgpool3::Pool& aclPool_;

    UidsPtr uidsPtr_;
    mutable std::shared_mutex readWriteLock_;

    maps::concurrent::BackgroundThread dataUpdater_;
};

class UserGroupsUidsCache :
    public std::map<UserGroup, std::unique_ptr<UserGroupUidsCache>> {};

} // namespace maps::wiki::acl_utils
