#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/caching_acl.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/feedback_preset_checker.h>
#include <yandex/maps/wiki/social/feedback/enums.h>
#include <yandex/maps/wiki/social/feedback/task.h>
#include <pqxx/pqxx>

namespace maps::wiki::acl_utils {

namespace sf = social::feedback;

class FeedbackChecker {
public:
    FeedbackChecker(
        CachingAclChecker& aclChecker,
        const FeedbackPresetChecker& fbPresetChecker);

    bool isAllowedToView(
        const sf::Task& task,
        const sf::History& history,
        acl::UID uid) const;

    bool isAllowedToModify(
        const sf::Task& task,
        acl::UID uid) const;

    sf::TaskOperations restrictValidOperations(
        const sf::TaskOperations& operations,
        const sf::Task& task,
        acl::UID uid) const;
    
    CachingAclChecker& aclChecker() const {
        return aclChecker_;
    }

    const FeedbackPresetChecker& fbPresetChecker() const {
        return fbPresetChecker_;
    }

private:
    CachingAclChecker& aclChecker_;
    const FeedbackPresetChecker& fbPresetChecker_;
};

} // namespace maps::wiki::acl_utils
