#pragma once

#include <maps/libs/concurrent/include/lru_cache.h>
#include <maps/libs/pgpool/include/pgpool3.h>
#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/caching_acl.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/common.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/mv_source_type.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/preset.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/feedback/task.h>

#include <map>

namespace maps::wiki::acl_utils {

namespace sf = social::feedback;

enum class PresetRightKind {
    View,
    Modify,
};

struct AssignedPreset
{
    AssignedPreset(social::TId presetId,
        sf::RoleKind roleKind,
        std::optional<social::TId> aoiId);

    social::TId presetId;
    sf::RoleKind roleKind;
    std::optional<social::TId> aoiId;
};

class AssignedPresetsExt
{
public:
    explicit AssignedPresetsExt(SteadyTimePoint loadedFromDB);

    void add(sf::Preset preset, sf::RoleKind roleKind, std::optional<social::TId> aoiId);

    std::vector<AssignedPreset> getAssignedPresets(PresetRightKind rightKind) const;
    const sf::Preset& requirePreset(social::TId presetId) const;
    SteadyTimePoint loadedFromDB() const;

private:
    std::vector<AssignedPreset> assignedPresets_;
    std::map<social::TId, sf::Preset> presetsById_;
    SteadyTimePoint loadedFromDB_;
};

/**
 * @brief Class for checking assigned Preset permissions for social::feedback::Task
 *
 */
class FeedbackPresetChecker
{
public:
    virtual ~FeedbackPresetChecker() = default;

    virtual bool isInAssignedPreset(acl::UID uid, const sf::Task& task, PresetRightKind rightKind) const = 0;
    virtual void restrictFilterByGlobalPresets(sf::TaskFilter& filter, social::TUid uid) const = 0;
    virtual void restrictFilterByGlobalPresets(sf::MvSourceTypeFilter& filter, social::TUid uid) const = 0;
    virtual AssignedPresetsExt getAssignedPresets(social::TUid uid) const = 0;
    virtual bool hasModifyPermission(
        acl::UID uid,
        const sf::Preset& preset,
        social::TId aoiId) const = 0;
};

class FeedbackPresetCheckerImpl : public FeedbackPresetChecker
{
public:
    FeedbackPresetCheckerImpl(
        pgpool3::Pool& corePool,
        pgpool3::Pool& socialPool,
        size_t maxCacheSize,
        std::chrono::seconds expirationPeriod)
        : corePool_(corePool)
        , socialPool_(socialPool)
        , cache_(maxCacheSize)
        , expirationPeriod_(expirationPeriod)
    {}

    bool isInAssignedPreset(acl::UID uid, const sf::Task& task, PresetRightKind rightKind) const override;
    void restrictFilterByGlobalPresets(sf::TaskFilter& filter, social::TUid uid) const override;
    void restrictFilterByGlobalPresets(sf::MvSourceTypeFilter& filter, social::TUid uid) const override;
    AssignedPresetsExt getAssignedPresets(social::TUid uid) const override;
    bool hasModifyPermission(
        acl::UID uid,
        const sf::Preset& preset,
        social::TId aoiId) const override;

private:
    sf::Presets getGlobalPresets(acl::UID uid, PresetRightKind rightKind) const;

    pgpool3::Pool& corePool_;
    pgpool3::Pool& socialPool_;
    mutable concurrent::LruCache<social::TUid, AssignedPresetsExt> cache_;
    std::chrono::seconds expirationPeriod_;
};

namespace internal {

bool match(const sf::TaskBrief& task, const sf::PresetEntries& entries);

}  // namespace internal

} // namespace maps::wiki::acl_utils
