#pragma once

#include <maps/wikimap/mapspro/libs/acl/include/aclgateway.h>
#include <maps/wikimap/mapspro/libs/acl/include/user.h>
#include <map>
#include <set>
#include <vector>

namespace maps::wiki::acl_utils {

bool hasRole(const std::vector<acl::Policy>& policies, const std::string& roleName);
bool hasRole(const acl::User& user, const std::string& roleName);

std::vector<std::string> moderationStatuses();

std::string
moderationStatus(const acl::ACLGateway& aclGtw, const acl::User& user);

std::map<acl::UID, std::string>
moderationStatuses(acl::ACLGateway& aclGtw, const std::vector<acl::User>& users);

std::map<acl::UID, std::string>
moderationStatuses(acl::ACLGateway& aclGtw, const std::set<acl::UID>& userIds);

std::map<std::string, std::vector<acl::UID>>
moderationStatusToUids(acl::ACLGateway& gateway, const std::vector<acl::User>& users);

std::vector<acl::UID>
uidsByModerationStatus(acl::ACLGateway& aclGateway, const std::string& modStatus);

bool isPieceworker(const std::vector<acl::Policy>& policies);
bool isOutsourcer(const std::vector<acl::Policy>& policies);
bool isOutsourcer(const acl::User& user);

std::vector<acl::UID> outsourcerUids(acl::ACLGateway& gateway);

bool isRobot(const std::string& moderationStatus);

bool isCartographer(const std::string& moderationStatus);

bool isCartographer(const acl::ACLGateway& aclgw, const acl::User& user);

bool isYandexModerator(const std::string& moderationStatus);

bool isModerator(const std::string& moderationStatus);

bool isModerator(const acl::ACLGateway& aclgw, const acl::User& user);

std::string createdOrUnbannedAt(const acl::User& user);

} // namespace maps::wiki::acl_utils
