#pragma once

#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/wikimap/mapspro/libs/acl/include/common.h>
#include <maps/wikimap/mapspro/libs/acl_utils/include/cached_moderation_statuses.h>

#include <set>
#include <vector>

namespace maps::wiki::acl_utils {

/**
 * UserKind describes sets of users,
 * whos uids are needed to be filtered out.
 *
 * E.g. sometimes its necessary to skip edits
 * by all Yandex employees,
 * or robots, or user's own:
 * https://st.yandex-team.ru/NMAPS-11263
 **/
// clang-format off
enum class UserKind {
    Robots,
    Self,
    Yandex
};
// clang-format on
DECLARE_ENUM_IO(UserKind);

std::set<acl::UID> userKindsToUids(
    const std::vector<UserKind>& userKinds,
    acl::UID selfUid,
    const UserGroupsUidsCache& cachedUids);

} // namespace maps::wiki::acl_utils
