#include "create.h"

#include <maps/wikimap/mapspro/libs/assessment/impl/magic_strings.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::assessment::competences {

TId create(pqxx::transaction_base& txn, const std::string& roleName)
{
    const auto result = txn.exec(
        "INSERT INTO " + sql::table::COMPETENCE + " "
            "(" + sql::col::ROLE_NAME + ") "
        "VALUES "
            "(" + txn.quote(roleName) + ") "
        "ON CONFLICT "
            "DO NOTHING "
        "RETURNING " +
            sql::col::COMPETENCE_ID);

    REQUIRE(
        result.affected_rows() == 1,
        "Inserted " << result.affected_rows() << " competences "
        "for role '" << roleName << "'");

    return result[0][sql::col::COMPETENCE_ID].as<TId>();
}

} // maps::wiki::assessment::competences
