#include <maps/wikimap/mapspro/libs/assessment/include/console.h>

#include "units/load.h"
#include "units/grade.h"
#include "units/status.h"
#include "units/grade_status.h"

#include "samples/load.h"
#include "samples/acquire.h"
#include "samples/release.h"
#include "samples/complete.h"

namespace maps::wiki::assessment {

Console::Console(pqxx::transaction_base& txn, TUid uid)
    : txn_{txn}
    , uid_{uid}
{}

Grade Console::gradeUnit(
    TId unitId,
    Grade::Value value,
    const std::optional<std::string>& comment,
    Qualification qualification)
{
    units::updateGradeStats(txn_, unitId, value, qualification);

    const auto grade = units::addGrade(txn_, uid_, unitId, value, comment, qualification);
    samples::tryCompleteTask(txn_, unitId, uid_, grade.id);

    return grade;
}

std::optional<Unit> Console::acquireUnit(TId sampleId, SkipAcquired skipAcquired)
{
    return samples::acquire(txn_, sampleId, uid_, skipAcquired);
}

void Console::releaseUnit(TId sampleId)
{
    samples::release(txn_, sampleId, uid_);
}

bool Console::tryFixUnit(TId unitId)
{
    return units::tryFix(txn_, uid_, unitId);
}

bool Console::tryAcceptRefutation(TId unitId)
{
    return units::tryAcceptRefutation(txn_, uid_, unitId);
}

UnitFeed Console::unitFeed(
    const UnitFeedParams& params,
    const UnitFilter& filter,
    GradesVisibility gradesVisibility) const
{
    return units::loadFeed(txn_, uid_, params, filter, gradesVisibility);
}

SampleFeed Console::sampleFeed(const SampleFeedParams& params, const SampleFilter& filter) const
{
    return samples::loadFeed(txn_, uid_, params, filter);
}

} // namespace maps::wiki::assessment
