#pragma once

#include <string>

namespace maps::wiki::assessment {

namespace sql {

namespace schema {

const std::string ASSESSMENT = "assessment";

} // namespace schema

namespace table {

const std::string COMPETENCE = schema::ASSESSMENT + ".competence";
const std::string GRADE = schema::ASSESSMENT + ".grade";
const std::string SAMPLE = schema::ASSESSMENT + ".sample";
const std::string SAMPLE_TASK = schema::ASSESSMENT + ".sample_task";
const std::string SAMPLE_TASK_COMPETENCE = schema::ASSESSMENT + ".sample_task_competence";
const std::string UNIT = schema::ASSESSMENT + ".unit";
const std::string UNIT_SKIP = schema::ASSESSMENT + ".unit_skip";

} // namespace table

namespace sequence {

const std::string GRADE_ID = schema::ASSESSMENT + ".grade_grade_id_seq";

} // namespace sequence

namespace col {

const std::string UNIT_ID = "unit_id";
const std::string ENTITY_ID = "entity_id";
const std::string ENTITY_DOMAIN = "entity_domain";
const std::string ACTION_BY = "action_by";
const std::string ACTION_AT = "action_at";
const std::string ACTION = "action";
const std::string LAST_EXPERT_VALUE = "last_expert_value";
const std::string LAST_GRADED_AT = "last_graded_at";
const std::string FIXED_AT = "fixed_at";

const std::string GRADE_ID = "grade_id";
const std::string GRADED_AT = "graded_at";
const std::string GRADED_BY = "graded_by";
const std::string VALUE = "value";
const std::string COMMENT = "comment";
const std::string REFUTATION_ACCEPTED_AT = "refutation_accepted_at";

const std::string SAMPLE_ID = "sample_id";
const std::string QUALIFICATION = "qualification";
const std::string NAME = "name";
const std::string CREATED_AT = "created_at";

const std::string SAMPLE_TASK_ID = "sample_task_id";
const std::string ACQUIRED_BY = "acquired_by";
const std::string ACQUIRED_AT = "acquired_at";

const std::string COMPETENCE_ID = "competence_id";
const std::string ROLE_NAME = "role_name";

const std::string SKIPPED_BY = "skipped_by";
const std::string SKIPPED_AT = "skipped_at";

} // namespace col

} // namespace sql

} // namespace maps::wiki::assessment
