#include "cleanup.h"

#include <maps/libs/chrono/include/format.h>
#include <maps/wikimap/mapspro/libs/assessment/impl/magic_strings.h>

namespace maps::wiki::assessment::samples {

size_t deleteOldUnitSkips(
    pqxx::transaction_base& txn,
    chrono::TimePoint olderThan)
{
    const auto query =
        "DELETE FROM " +
            sql::table::UNIT_SKIP + " "
        "WHERE " +
            sql::col::SKIPPED_AT + " < '" + chrono::formatSqlDateTime(olderThan) + "'";

    return txn.exec(query).affected_rows();
}

} // maps::wiki::assessment::samples
