#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/sample.h>
#include <maps/wikimap/mapspro/libs/assessment/include/sample_feed.h>
#include <maps/wikimap/mapspro/libs/assessment/include/sample_filter.h>
#include <pqxx/pqxx>

namespace maps::wiki::assessment::samples {

std::optional<SampleInfo> loadById(
    pqxx::transaction_base& txn,
    TId sampleId);

SampleFeed loadFeed(
    pqxx::transaction_base& txn,
    const std::optional<TUid>& uid,
    const SampleFeedParams& params,
    const SampleFilter& filter);

bool existsByName(
    pqxx::transaction_base& txn,
    const std::string& name);

} // maps::wiki::assessment::samples
