#include "release.h"

#include <maps/wikimap/mapspro/libs/assessment/impl/magic_strings.h>
#include <maps/libs/common/include/exception.h>

namespace maps::wiki::assessment::samples {

void release(
    pqxx::transaction_base& txn,
    TId sampleId,
    TUid acquiredBy)
{
    const auto result = txn.exec(
        "UPDATE " + sql::table::SAMPLE_TASK + " "
        "SET " +
            sql::col::ACQUIRED_AT + " = NULL, " +
            sql::col::ACQUIRED_BY + " = NULL "
        "WHERE " +
            sql::col::GRADE_ID + " IS NULL AND " +
            sql::col::SAMPLE_ID + " = " + std::to_string(sampleId) + " AND " +
            sql::col::ACQUIRED_BY + " = " + std::to_string(acquiredBy));

    REQUIRE(
        result.affected_rows() <= 1,
        "Released " << result.affected_rows() << " tasks "
        "in sample " << sampleId << " acquired by " << acquiredBy);
}

} // maps::wiki::assessment::samples
