#include <maps/wikimap/mapspro/libs/assessment/include/unit.h>

#include <maps/libs/enum_io/include/enum_io.h>

namespace maps::wiki::assessment {

constexpr maps::enum_io::Representations<Grade::Value>
GRADE_VALUE_REPRESENTATION {
    {Grade::Value::Incorrect, "incorrect"},
    {Grade::Value::Correct,   "correct"}
};
DEFINE_ENUM_IO(Grade::Value, GRADE_VALUE_REPRESENTATION);

constexpr maps::enum_io::Representations<Entity::Domain>
ENTITY_DOMAIN_REPRESENTATION {
    {Entity::Domain::Edits,      "edits"},
    {Entity::Domain::Feedback,   "feedback"},
    {Entity::Domain::Moderation, "moderation"},
    {Entity::Domain::Tracker,    "tracker"}
};
DEFINE_ENUM_IO(Entity::Domain, ENTITY_DOMAIN_REPRESENTATION);

constexpr maps::enum_io::Representations<Qualification>
QUALIFICATION_RESPRESENTATION {
    {Qualification::Basic,  "basic"},
    {Qualification::Expert, "expert"}
};
DEFINE_ENUM_IO(Qualification, QUALIFICATION_RESPRESENTATION);

constexpr maps::enum_io::Representations<UnitStatus>
UNIT_STATUS_REPRESENTATION {
    {UnitStatus::Correct,   "correct"},
    {UnitStatus::Incorrect, "incorrect"},
    {UnitStatus::Fixed,     "fixed"}
};
DEFINE_ENUM_IO(UnitStatus, UNIT_STATUS_REPRESENTATION);

constexpr maps::enum_io::Representations<GradeStatus>
GRADE_STATUS_REPRESENTATION {
    {GradeStatus::Confirmed,          "confirmed"},
    {GradeStatus::Refuted,            "refuted"},
    {GradeStatus::RefutationAccepted, "refutation-accepted"},
};
DEFINE_ENUM_IO(GradeStatus, GRADE_STATUS_REPRESENTATION);

} // namespace maps::wiki::assessment
