#include "create.h"

#include <maps/wikimap/mapspro/libs/assessment/impl/sql_helpers.h>
#include <maps/wikimap/mapspro/libs/assessment/impl/magic_strings.h>

namespace maps::wiki::assessment::units {

namespace {

const std::string SQL_ENTITY_ACTION_COLUMNS =
    "(" +
        sql::col::ENTITY_ID + ", " +
        sql::col::ENTITY_DOMAIN + ", " +
        sql::col::ACTION_BY + ", " +
        sql::col::ACTION_AT + ", " +
        sql::col::ACTION +
    ")";

const std::string SQL_NON_FEEDBACK_CONFLICT_COLUMNS =
    "(" +
        sql::col::ENTITY_ID + ", " +
        sql::col::ENTITY_DOMAIN + ", " +
        sql::col::ACTION_BY + ", " +
        sql::col::ACTION +
    ")";

const std::string SQL_ENTITY_DOMAIN_IS_NOT_FEEDBACK =
    sql::col::ENTITY_DOMAIN + " != '" + std::string(toString(Entity::Domain::Feedback)) + "'";

std::string sqlEntityActionRow(pqxx::transaction_base& txn, const Entity& entity, const Action& action)
{
    return
        "(" +
            txn.quote(entity.id) + ", " +
            sqlEnumToString(txn, entity.domain) + ", " +
            std::to_string(action.by) + ", " +
            txn.quote(chrono::formatSqlDateTime(action.at)) + ", " +
            txn.quote(action.name) +
        ")";
}

std::string sqlConflictTarget(Entity::Domain entityDomain)
{
    if (entityDomain == Entity::Domain::Feedback) {
        return SQL_ENTITY_ACTION_COLUMNS;
    }
    return SQL_NON_FEEDBACK_CONFLICT_COLUMNS + " WHERE " + SQL_ENTITY_DOMAIN_IS_NOT_FEEDBACK;
}

} // namespace

TId create(pqxx::transaction_base& txn, const Entity& entity, const Action& action)
{
    const auto result = txn.exec(
        "INSERT INTO " + sql::table::UNIT + " " +
            SQL_ENTITY_ACTION_COLUMNS + " "
        "VALUES " +
            sqlEntityActionRow(txn, entity, action) + " "
        "ON CONFLICT " +
            sqlConflictTarget(entity.domain) + " "
        "DO " + // fake update statement
            "UPDATE SET " + sql::col::ENTITY_ID + " = EXCLUDED." + sql::col::ENTITY_ID + " "
        "RETURNING " +
            sql::col::UNIT_ID);

    REQUIRE(result.size() == 1, "Upserted unexpected number of units: " << result.size());
    return result[0][sql::col::UNIT_ID].as<TId>();
}

} // namespace maps::wiki::assessment::units
