#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/sample_feed.h>
#include <maps/wikimap/mapspro/libs/assessment/include/sample_filter.h>
#include <maps/wikimap/mapspro/libs/assessment/include/unit_feed.h>
#include <maps/wikimap/mapspro/libs/assessment/include/unit_filter.h>

#include <pqxx/pqxx>

namespace maps::wiki::assessment {

class Gateway;

class Console
{
public:
    Grade gradeUnit(
        TId unitId,
        Grade::Value value,
        const std::optional<std::string>& comment,
        Qualification qualification);

    std::optional<Unit> acquireUnit(TId sampleId, SkipAcquired skipAcquired);
    void releaseUnit(TId sampleId);

    bool tryFixUnit(TId unitId);
    bool tryAcceptRefutation(TId unitId);

    /* may require uid to know which grades to hide/ignore */
    UnitFeed unitFeed(const UnitFeedParams& params, const UnitFilter& filter, GradesVisibility gradesVisibility) const;

    /* feed items contain uid's completed sample_task count */
    SampleFeed sampleFeed(const SampleFeedParams& params, const SampleFilter& filter) const;

private:
    friend class maps::wiki::assessment::Gateway;
    Console(pqxx::transaction_base& txn, TUid uid);

    pqxx::transaction_base& txn_;
    const TUid uid_;
};

} // namespace maps::wiki::assessment
