#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/console.h>

namespace maps::wiki::assessment {

class Gateway
{
public:
    Gateway(pqxx::transaction_base& txn);

    void checkEntityAction(const Entity& entity, const Action& action) const;
    TId getOrCreateUnit(const Entity& entity, const Action& action);

    TId getOrCreateCompetence(const std::string& roleName);
    CompetenceVec loadCompetences(const std::vector<std::string>& roleNames) const;

    TId createSample(
        Entity::Domain domain,
        Qualification qualification,
        const std::string& name,
        TIds unitIds,
        size_t tasksPerUnit);

    SampleInfo findSample(TId sampleId) const;
    bool sampleExistsByName(const std::string& name) const;
    UnitGradeStatsVec sampleGradeStats(TId sampleId) const;

    size_t deleteOldUnitSkips(chrono::TimePoint olderThan);

    Console console(TUid uid) const;

private:
    void checkFeedbackAction(TId feedbackTaskId, const Action& action) const;

    pqxx::transaction_base& txn_;
};

} // namespace maps::wiki::assessment
