#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/unit.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/rate_limiter_config_loader.h>
#include <maps/libs/xml/include/xml.h>
#include <pqxx/pqxx>
#include <chrono>
#include <map>
#include <optional>
#include <vector>

namespace maps::wiki::assessment {

class RateLimiter
{
public:
    explicit RateLimiter(const maps::xml3::Node& node);

    std::optional<std::chrono::seconds> checkTotalLimitExceeded(
        pqxx::transaction_base& txn,
        TUid uid) const;

    std::optional<std::chrono::seconds> checkLimitExceeded(
        pqxx::transaction_base& txn,
        TUid uid,
        Entity::Domain entityDomain) const;

protected:
    RateLimiter() = default;

    using Limits = social::RateLimiterConfigLoader::Limits;

    Limits totalLimits_;
    std::map<Entity::Domain, Limits> entityDomainLimits_;
};

} // namespace maps::wiki::assessment
