#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/unit.h>

namespace maps::wiki::assessment {

using introspection::operator<;
using introspection::operator==;

struct Competence
{
    TId id;
    std::string roleName;

    auto introspect() const { return std::tie(id, roleName); }
};
using CompetenceVec = std::vector<Competence>;

struct SampleAssessorStats
{
    TUid uid;
    uint64_t gradedCount;
    chrono::TimePoint recentGradedAt;
};
using SampleAssessorStatsVec = std::vector<SampleAssessorStats>;

struct SampleInfo
{
    struct AssessorStats
    {
        TUid uid;
        uint64_t gradedCount;
        chrono::TimePoint recentGradedAt;
    };

    TId id;
    Entity::Domain entityDomain;
    Qualification qualification;
    chrono::TimePoint createdAt;
    std::string name;
    uint64_t gradedCount;
    uint64_t totalCount;
    std::vector<AssessorStats> assessorsStats;
};
using SampleInfoVec = std::vector<SampleInfo>;

enum class SkipAcquired : bool
{
    Yes = true,
    No = false
};

struct UnitGradeStats {
    TId unitId;
    unsigned correct;
    unsigned incorrect;
};
using UnitGradeStatsVec = std::vector<UnitGradeStats>;

} // namespace maps::wiki::assessment
