#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/sample.h>

namespace maps::wiki::assessment {

class SampleFeedParams
{
public:
    static constexpr size_t perPageDefault = 10;

    SampleFeedParams(TId before, TId after, size_t perPage)
        : before_(before)
        , after_(after)
        , perPage_(perPage)
    {}

    TId before() const { return before_; };
    TId after() const { return after_; };
    size_t perPage() const { return perPage_; };

private:
    TId before_;
    TId after_;
    size_t perPage_;
};

class SampleFeed
{
public:
    SampleFeed(SampleInfoVec&& samples, bool hasMore)
        : samples_(samples)
        , hasMore_(hasMore)
    {}

    const SampleInfoVec& samples() const { return samples_; }
    bool hasMore() const { return hasMore_; }

private:
    SampleInfoVec samples_;
    bool hasMore_;
};

} // namespace maps::wiki::assessment
