#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/sample.h>
#include <maps/wikimap/mapspro/libs/social/include/yandex/maps/wiki/social/date_time_condition.h>

namespace maps::wiki::assessment {

class SampleFilter
{
public:
    SampleFilter& entityDomain(Entity::Domain value) { entityDomain_ = value; return *this; }
    SampleFilter& qualification(Qualification value) { qualification_ = value; return *this; }
    SampleFilter& graded(bool value) { graded_ = value; return *this; }
    SampleFilter& createdAt(const social::DateTimeCondition& condition) { createdAt_ = condition; return *this; }
    SampleFilter& nameLike(std::string pattern) { nameLike_.emplace_back(std::move(pattern)); return *this; }
    SampleFilter& nameNotLike(std::string pattern) { nameNotLike_.emplace_back(std::move(pattern)); return *this; }

    const std::optional<Entity::Domain>& entityDomain() const { return entityDomain_; }
    const std::optional<Qualification>& qualification() const { return qualification_; }
    const std::optional<bool>& graded() const { return graded_; }
    const std::optional<social::DateTimeCondition>& createdAt() const { return createdAt_; }
    const std::vector<std::string>& nameLike() const { return nameLike_; }
    const std::vector<std::string>& nameNotLike() const { return nameNotLike_; }

private:
    std::optional<Entity::Domain> entityDomain_;
    std::optional<Qualification> qualification_;
    std::optional<bool> graded_;
    std::optional<social::DateTimeCondition> createdAt_;
    std::vector<std::string> nameLike_;
    std::vector<std::string> nameNotLike_;
};

} // namespace maps::wiki::assessment
