#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/unit.h>

namespace maps::wiki::assessment {

class UnitFeedParams
{
public:
    static constexpr size_t perPageDefault = 10;

    UnitFeedParams(TId before, TId after, size_t perPage)
        : before_(before)
        , after_(after)
        , perPage_(perPage)
    {}

    TId before() const { return before_; };
    TId after() const { return after_; };
    size_t perPage() const { return perPage_; };

private:
    TId before_;
    TId after_;
    size_t perPage_;
};

class UnitFeed
{
public:
    UnitFeed(GradedUnitVec&& units, bool hasMore)
        : units_(units)
        , hasMore_(hasMore)
    {}

    const GradedUnitVec& units() const { return units_; }
    bool hasMore() const { return hasMore_; }

private:
    GradedUnitVec units_;
    bool hasMore_;
};

} // namespace maps::wiki::assessment
