#pragma once

#include <maps/wikimap/mapspro/libs/assessment/include/unit.h>

#include <set>
#include <string>


namespace maps::wiki::assessment {

using StringSet = std::set<std::string>;


class UnitFilter
{
public:
    UnitFilter& entityDomain(Entity::Domain value) { entityDomain_ = value; return *this; }
    UnitFilter& entityIds(StringSet value) { entityIds_ = std::move(value); return *this; }
    UnitFilter& actionBy(TUid value) { actionBy_ = value; return *this; }
    UnitFilter& graded(bool value) { graded_ = value; return *this; }
    UnitFilter& gradedBy(TUid value) { gradedBy_ = value; return *this; }
    UnitFilter& gradeValue(Grade::Value value) { gradeValue_ = value; return *this; }
    UnitFilter& gradeConfirmed(bool value) { gradeConfirmed_ = value; return *this; }
    UnitFilter& gradeStatus(GradeStatus value) { gradeStatus_ = value; return *this; }
    UnitFilter& status(UnitStatus value) { status_ = value; return *this; }

    const std::optional<Entity::Domain>& entityDomain() const { return entityDomain_; }
    const std::optional<StringSet>& entityIds() const { return entityIds_; }
    const std::optional<TUid>& actionBy() const { return actionBy_; }
    const std::optional<bool>& graded() const { return graded_; }
    const std::optional<TUid>& gradedBy() const { return gradedBy_; }
    const std::optional<Grade::Value>& gradeValue() const { return gradeValue_; }
    const std::optional<bool>& gradeConfirmed() const { return gradeConfirmed_; }
    const std::optional<GradeStatus>& gradeStatus() const { return gradeStatus_; }
    const std::optional<UnitStatus>& status() const { return status_; }

private:
    std::optional<Entity::Domain> entityDomain_;
    std::optional<StringSet> entityIds_;
    std::optional<TUid> actionBy_;
    std::optional<bool> graded_;
    std::optional<TUid> gradedBy_;
    std::optional<Grade::Value> gradeValue_;
    std::optional<bool> gradeConfirmed_;
    std::optional<GradeStatus> gradeStatus_;
    std::optional<UnitStatus> status_;
};

} // namespace maps::wiki::assessment
