#pragma once

#include "push_info.h"

#include <maps/libs/common/include/retry.h>
#include <maps/libs/http/include/http.h>

#include <string>
#include <optional>

namespace maps::wiki::bell_client {

struct Configuration {
    Configuration(
        std::string baseUrl,
        std::string supToken,
        std::string project,
        std::string service
    )
        : baseUrl(std::move(baseUrl))
        , supToken(std::move(supToken))
        , project(std::move(project))
        , service(std::move(service))
    { }

    std::string baseUrl;
    std::string supToken;

    std::string project;
    std::string service;

    bool dryRun = false;
    maps::common::RetryPolicy retryPolicy;
};

class Client {
public:
    explicit Client(Configuration configuration)
        : configuration_(std::move(configuration))
    { }

    // Returns unique ID of the push
    std::string push(const PushInfo& pushInfo);

private:
    http::HeaderMap constructHeaders() const;

    Configuration configuration_;
    http::Client httpClient_;
};

}
