#pragma once

#include <maps/libs/json/include/value.h>
#include <maps/libs/enum_io/include/enum_io_fwd.h>
#include <maps/wikimap/mapspro/libs/types/include/uid.h>

#include <string>
#include <optional>

namespace maps::wiki::bell_client {

using Uid = types::TUid;

enum class NotificationType {
    Default,
    NmapsEditsRelease
};

DECLARE_ENUM_IO(NotificationType);

struct PushInfo {
    PushInfo(
        Uid uid,
        std::string actor,
        NotificationType type,
        json::Value meta
    )
        : uid(uid)
        , actor(std::move(actor))
        , type(type)
        , meta(std::move(meta))
    { }

    Uid uid;

    std::string actor;
    NotificationType type;

    json::Value meta;

    // This will be put in push_type by the service. If it is not present,
    // bell_features.type will be used.
    std::optional<std::string> pushId{std::nullopt};
    // During this much time (in seconds) attempts so send the push will be made
    uint64_t ttl{3600};

    std::optional<std::string> groupKey{std::nullopt};
};

}
